﻿<%@ Page Title="" Language="C#" MasterPageFile="~/TBI_Instruments/RegistryInstrument.master" AutoEventWireup="true" CodeFile="TimedUpAndGo.aspx.cs" Inherits="TBI_Instruments_TimedUpAndGo" %>

<%@ Import Namespace="VeteransAffairs.Registries.Business" %>
<%@ Register Assembly="Telerik.Web.UI" Namespace="Telerik.Web.UI" TagPrefix="telerik" %>
<%@ Register Assembly="AjaxControlToolkit" Namespace="AjaxControlToolkit" TagPrefix="ajaxToolkit" %>
<%@ Register TagPrefix="VA" TagName="TbiDiagnosisSelector" Src="~/controls/TbiDiagnosisSelector.ascx" %>

<asp:Content ID="Content1" ContentPlaceHolderID="head" runat="Server">
    <link type="text/css" href="~/styles/StyleSheet.css" />
    <style type="text/css">
        .breadcrumbInstrument
        {
            background-color: #6B1424;
            border-bottom: 1px solid #000;
            color: #FFF;
            font-family: Verdana, Geneva, Arial, Helvetica, sans-serif;
            font-variant: small-caps;
            font-weight: 700;
            letter-spacing: 1px;
            margin: 2px 0 2px 0;
            padding: 8px 25px 5px 10px;
        }
        .detailTable
        {
            border: 0px;
            background-color: #FFFFFF;
        }
        .detailTable td
        {
            border: 0px;
            background-color: #FFFFFF;
        }
        .requiredField 
        {
        	font-weight:bold;
        	color:#FF0000;
        }
    </style>
</asp:Content>


<asp:Content ID="Content2" ContentPlaceHolderID="ContentPlaceHolder" Runat="Server">
    <asp:ScriptManager ID="ScriptManager1" ScriptMode="Release" runat="server">
    </asp:ScriptManager>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock1">

        <script type="text/javascript">
            Sys.WebForms.PageRequestManager.getInstance().add_beginRequest(startRequest);
            Sys.WebForms.PageRequestManager.getInstance().add_endRequest(endRequest);

            function startRequest(sender, e) {
                //disable button during the AJAX call
                document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = true;
                document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = true;
                document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = true;
            }
            function endRequest(sender, e) {
                //re-enable button once the AJAX call has completed
                document.getElementById('<%=btnSaveSurveyDraft.ClientID%>').disabled = false;
                document.getElementById('<%=btnSubmitSurvey.ClientID%>').disabled = false;
                document.getElementById('<%=btnCancelSurvey.ClientID%>').disabled = false;
            }
        </script>
        <script type="text/javascript">
            $(document).ready(function() {

                // Disables 'Enter' Key from posting back on any input 
                // element ( textbox, radiolist, checkbox, etc )
                $('input').keydown(function(e) {
                    if (e.keyCode == 13) { return false; }
                });

                // Disables 'Enter' Key from posting back when no input 
                // element is in focus, and the enter key is pressed 
                $('div').keydown(function(e) {
                    if (e.keyCode == 13) { return false; }
                });

            }); // END $(document).ready(function()
        </script>
        <script type="text/javascript">
            $(document).ready(function () {
               $('input:text').keydown(function(e) {
                    //cancel enter to prevent errors
                    if (e.keyCode == 13)
                        return false;
                });

                //processPersonReporting_Click();
                //processRadioButtonQ_Click();

                window.onbeforeunload = function () {
                    //Save draft if timeout occurs
                    document.getElementById('<%= btnSaveSurveyDraft.ClientID %>').click();
                   // return;
                }

            }); // END $(document).ready(function()

        </script>

    </telerik:RadCodeBlock>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock2">
        <div class="breadcrumbInstrument">
            <asp:Label ID="LabelBreadCrumb" runat="server" Text="TBI Instruments > Instrument Associations > Timed Up and Go"></asp:Label>
        </div>
    </telerik:RadCodeBlock>
    <telerik:RadCodeBlock runat="server" ID="RadCodeBlock3">
        <asp:UpdatePanel ID="MainUpdatePanel" runat="server">
            <ContentTemplate>
                <asp:UpdateProgress ID="MainUpdateProgress" runat="server">
                    <ProgressTemplate>
                        <!-- Modal Popup for Loading -->
                        <div style="padding-left: 3px;">
                            <div style="background-color: #FF0000; width: 170px; color: #FFFFFF; padding: 5px;">
                                Processing...Please wait.
                            </div>
                        </div>
                        <%--<div style="background-color: Gray; filter: alpha(opacity=50); opacity: 0.50; width: 100%; top: 0px; left: 0px; position: fixed;
                            height: 100%;">
                        </div>
                        <div style="margin: auto; font-family: Trebuchet MS; filter: alpha(opacity=100); opacity: 1; font-size: small; vertical-align: middle;
                            top: 45%; position: fixed; right: 45%; color: #232323; text-align: center; background-color: White; height: 100px;">
                            <table style="background-color: White; font-family: Sans-Serif; text-align: center; border: solid 1px #232323; color: #232323;
                                width: 300px; height: inherit; padding: 15px;">
                                <tr>
                                    <td style="text-align: inherit;">
                                        <img src="images/loading_image.gif" alt="Loading" title="Loading Image" />
                                    </td>
                                    <td style="text-align: inherit;">
                                        <span style="font-family: Sans-Serif; font-size: medium; font-weight: bold; font">Processing...Please wait.</span>
                                    </td>
                                </tr>
                            </table>
                        </div>--%>
                        <!-- End Modal Popup for Loading -->
                    </ProgressTemplate>
                </asp:UpdateProgress>
                <asp:ValidationSummary ID="TBIInstrumentsValidationSummaryOnSave" runat="server" TabIndex="1" HeaderText="The page has the following data errors:"
                    DisplayMode="BulletList" ShowSummary="false" ShowMessageBox="true" ValidationGroup="OnSave" />
                <asp:Panel ID="PanelPatient" Width="100%" GroupingText="&nbsp;&nbsp;Patient&nbsp;&nbsp;" runat="server">
                    <table cellpadding="5" cellspacing="5">
                        <tr>
                            <td>
                                &nbsp;&nbsp;<asp:Label ID="LabelForName" runat="server" Text="Patient:" AssociatedControlID="LabelPatient"></asp:Label>&nbsp;<asp:Label
                                    ID="LabelPatient" runat="server" SkinID="DataLabel" TabIndex="2"></asp:Label>
                            </td>
                            <td>
                                <asp:Label ID="LabelForSSN" runat="server" SkinID="DataLabel" AssociatedControlID="LabelSSN" Text="SSN:"></asp:Label>
                                &nbsp;<asp:Label ID="LabelSSN" runat="server" SkinID="DataLabel" TabIndex="3"></asp:Label>
                            </td>
                            <td>
                                <asp:Label ID="LabelForFacility" runat="server" SkinID="DataLabel" AssociatedControlID="LabelFacility" Text="Facility:" Visible="false"></asp:Label>
                                &nbsp;<asp:Label ID="LabelFacility" runat="server" SkinID="DataLabel" TabIndex="4"></asp:Label>
                            </td>
                        </tr>
                    </table>
                </asp:Panel>
                <!-- Hidden Field - Survey Type -->
                <asp:HiddenField ID="HiddenSurveyType" runat="server" Visible="false" Value="TUG" />
                <asp:Panel ID="PanelSurveyHeader" Width="100%" runat="server" CssClass="mainContent">
                    <br />
                    <asp:Label ID="LabelInstrumentTitle" runat="server" Style="font-weight: bold" />&nbsp;-&nbsp;
                    <asp:LinkButton ID="lnkBtnToggleInstructions" runat="server" Text="Click for Instructions" ToolTip="Click to show/hide instructions."
                        OnClick="lnkBtnToggleInstructions_OnClick" TabIndex="10" />
                    <br />
                </asp:Panel>
                <!-- Instruction Area -->
                <asp:Panel ID="PanelInstructions" runat="server" Visible="false">
                    <br />
                    <table style="width:800px;">
                        <td style="width: 30px;">
                                &nbsp;
                        </td>
                        <td>
                            <div style="padding: 5px; width: 700px;">
                                <h2>
                                    Directions for the Timed "Get Up & Go Test"</h2>
                                The timed "Get Up & Go" test measures, in seconds, the time taken by an individual to stand up from a standard arm chair (approximate seat height of 46 cm, arm height 65 cm), walk a distance of 3 meters (approximately 10 feet), turn, walk back to the chair, and sit down again. The subject wears his/her regular footwear and uses his customary walking aid (none, cane, or walker). No physical assistance is given. The subject starts with his back against the chair, arms resting on the armrests, and walking aid at hand. He is instructed that, on the word “Go” he is to get up and walk at comfortable and safe pace to a line on the floor 3 meters away, turn, return to the chair, and sit down again. The subject walks through the test once before being timed in order to become familiar with the test. Either a wrist-watch with a second hand or a stop-watch can be used to time the performance.
                            </div>
                        </td>
                    </table>
                </asp:Panel>
                <!-- End Instruction Area -->
                
                
                <asp:Panel ID="PanelQuestions" Width="100%" runat="server" CssClass="mainContent">
                    <br />
                    <!-- Question Area -->
                    <table style="width:800px;">
                        
                        <tr>
                            <td style="width: 40px;">
                                &nbsp;
                            </td>
                            <td>
                                <!-- Diagnosis Control -->
                                <!-- Set Question Text, SurveyTypeId, SurveyTypeCode in the page_load -->
                                <VA:TbiDiagnosisSelector ID="ctrlDiagnosis" runat="server" QuestionNumber="DX" StartTabIndex="15" />
                            </td>
                        </tr>
                    </table>
                    <table style="width:800px;">
                        <tr>
                            <td style="width: 20px;">
                                &nbsp;
                            </td>
                            <td style="width: 200px;">
                                <asp:Label ID="LabelDate1" runat="server" AssociatedControlID="dpDate1" SkinID="DataLabel" TabIndex="30">
                                </asp:Label> <span class="requiredField">*</span>
                            </td>
                            <td>
                                <telerik:RadDatePicker ID="dpDate1" runat="server" TabIndex="31">
                                    <Calendar ID="calDate1" runat="server">
                                    </Calendar>
                                </telerik:RadDatePicker>
                                
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorDate1" runat="server" ControlToValidate="dpDate1" TabIndex="32" ValidationGroup="OnSave"
                                    Display="Dynamic" ErrorMessage="* Date is required."></asp:RequiredFieldValidator>
                                <br />
                            </td>
                        </tr>
                    </table>
                    
                    <table width="100%">
                    
                        <%-- Assistive Device --%>       
                        <tr>
                            <td style="width: 20px;">       
                                &nbsp;
                            </td>
                            <td colspan="2">
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ1" runat="server" AssociatedControlID="rblQ1" SkinID="DataLabel" TabIndex="33">
                                </asp:Label> <span class="requiredField">*</span>
                                <br />
                                <%--Assistive Device Question List--%>
                                <asp:RadioButtonList ID="rblQ1" runat="server" RepeatDirection="Horizontal" AutoPostBack="True" DataSourceID="ObjectDataSourceQ1"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID" OnSelectedIndexChanged="rblQ1_SelectedIndexChanged"
                                    TabIndex="34">
                                </asp:RadioButtonList>
                                <%--Assistive Device Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ1" runat="server" ControlToValidate="rblQ1"
                                    TabIndex="35" ValidationGroup="OnSave" Display="Dynamic" ErrorMessage="* Assistive Device answer is required."></asp:RequiredFieldValidator>
                                <%--Assistive Device Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ1" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType"
                                    TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ1" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Assistive Device Question Number--%>
                                <asp:HiddenField ID="HiddenQ1" runat="server" Visible="false" Value="1" />
                            </td>
                        </tr>
                        
                        <%-- Assistive Device Selection --%>
                        <tr>
                            <td>
                                &nbsp;
                            </td>
                            <td colspan="2">
                                <asp:Panel ID="pnlAssistiveDeviceSelection" runat="server" Visible="false">
                                    <!-- Get text in code-behind -->
                                    <asp:Label ID="LabelForQ2" runat="server" AssociatedControlID="rblQ2" SkinID="DataLabel" TabIndex="36">
                                    </asp:Label> <span class="requiredField">*</span>
                                    <br />
                                    <%--Assistive Device Selection Question List--%>
                                    <asp:RadioButtonList ID="rblQ2" runat="server" DataSourceID="ObjectDataSourceQ2"
                                        TabIndex="37" DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID">
                                    </asp:RadioButtonList>
                                    <%--Assistive Device Selection Question Required Validator--%>
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ2" runat="server" ControlToValidate="rblQ2"
                                        TabIndex="38" ValidationGroup="OnSave" Display="Dynamic" ErrorMessage="* Assistive Device selection is required."></asp:RequiredFieldValidator>
                                    <%--Assistive Device Selection Object Data Source--%>
                                    <asp:ObjectDataSource ID="ObjectDataSourceQ2" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType"
                                        TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                        <SelectParameters>
                                            <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                            <asp:ControlParameter ControlID="HiddenQ2" Direction="Input" Name="questionNumber" Type="String" />
                                        </SelectParameters>
                                    </asp:ObjectDataSource>
                                    <%--Assistive Device Selection Question Number--%>
                                    <asp:HiddenField ID="HiddenQ2" runat="server" Visible="false" Value="2" />
                                </asp:Panel>
                            </td>
                        </tr>                        
                    
                        <tr>
                            <td colspan="100%">
                                &nbsp;
                            </td>
                        </tr>
                        
                        
                        <tr>
                            <td>
                                &nbsp;
                            </td>
                            <td colspan="2">
                                <table cellpadding="5" cellspacing="5">
                                    <tr>
                                        <td>
                                            <%-- Time - Test 1 --%>
                                            <asp:Label ID="LabelForQ3" runat="server" AssociatedControlID="txtQ3" SkinID="DataLabel" TabIndex="41">
                                            </asp:Label> <span class="requiredField">*</span>
                                            <br />
                                            <asp:TextBox ID="txtQ3" runat="server" MaxLength="4" Width="50px" TabIndex="42"></asp:TextBox>&nbsp;sec.
                                            <br />
                                            <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ3" runat="server" ControlToValidate="txtQ3" ValidationGroup="OnSave"
                                                TabIndex="43" Display="Dynamic" ErrorMessage="* Time Entry is required."></asp:RequiredFieldValidator>
                                            <asp:RangeValidator ID="RangeValidatorQ3" runat="server" ControlToValidate="txtQ3" ErrorMessage="Time Entry must be a positive integer"
                                                TabIndex="44" MaximumValue="9999" MinimumValue="0" SetFocusOnError="true" ValidationGroup="OnSave" Type="Integer" Display="Dynamic">
                                            </asp:RangeValidator>
                                        </td>
                                        <td style="width: 10px;">
                                            &nbsp;
                                        </td>
                                        <td>
                                            <%-- Distance - Test 1 --%>
                                            <asp:Label ID="LabelForQ4" runat="server" AssociatedControlID="txtQ4" SkinID="DataLabel" TabIndex="45">
                                            </asp:Label> <span class="requiredField">*</span>
                                            <br />
                                            <asp:TextBox ID="txtQ4" runat="server" MaxLength="2" Width="50px" TabIndex="46">3</asp:TextBox>&nbsp;m
                                            <br />
                                            <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ4" runat="server" ControlToValidate="txtQ4"
                                                TabIndex="47" ValidationGroup="OnSave" Display="Dynamic" ErrorMessage="* Distance Entry is required."></asp:RequiredFieldValidator>
                                            <asp:RangeValidator ID="RangeValidatorQ4" runat="server" ControlToValidate="txtQ4" ErrorMessage="Distance Entry must be a positive integer"
                                                MaximumValue="99" MinimumValue="0" SetFocusOnError="true" ValidationGroup="OnSave" Type="Integer" Display="Dynamic" TabIndex="48">
                                            </asp:RangeValidator>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                        
                        <tr>
                            <td>
                                &nbsp;
                            </td>
                            <td colspan="2">
                                <table cellpadding="5" cellspacing="5">
                                    <tr>
                                        <td>
                                             <%-- Time - Test 2 --%>
                                            <asp:Label ID="LabelForQ5" runat="server" AssociatedControlID="txtQ5" SkinID="DataLabel" TabIndex="51">
                                            </asp:Label> <span class="requiredField">*</span>
                                            <br />
                                            <asp:TextBox ID="txtQ5" runat="server" MaxLength="4" Width="50px" TabIndex="52"></asp:TextBox>&nbsp;sec.
                                            <br />
                                            <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ5" runat="server" ControlToValidate="txtQ5" ValidationGroup="OnSave"
                                                TabIndex="53" Display="Dynamic" ErrorMessage="* Time Entry is required."></asp:RequiredFieldValidator>
                                            <asp:RangeValidator ID="RangeValidatorQ5" runat="server" ControlToValidate="txtQ5" ErrorMessage="Time Entry must be a positive integer"
                                                TabIndex="54" MaximumValue="9999" MinimumValue="0" SetFocusOnError="true" ValidationGroup="OnSave" Type="Integer" Display="Dynamic">
                                            </asp:RangeValidator>
                                        </td>
                                        <td style="width: 10px;">
                                            &nbsp;
                                        </td>
                                        <td>
                                             <%-- Distance - Test 2 --%>
                                            <asp:Label ID="LabelForQ6" runat="server" AssociatedControlID="txtQ6" SkinID="DataLabel" TabIndex="55">
                                            </asp:Label> <span class="requiredField">*</span>
                                            <br />
                                            <asp:TextBox ID="txtQ6" runat="server" MaxLength="2" Width="50px" TabIndex="56">3</asp:TextBox>&nbsp;m
                                            <br />
                                            <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ6" runat="server" ControlToValidate="txtQ6"
                                                TabIndex="57" ValidationGroup="OnSave" Display="Dynamic" ErrorMessage="* Distance Entry is required."></asp:RequiredFieldValidator>
                                            <asp:RangeValidator ID="RangeValidatorQ6" runat="server" ControlToValidate="txtQ6" ErrorMessage="Distance Entry must be a positive integer"
                                                MaximumValue="99" MinimumValue="0" SetFocusOnError="true" ValidationGroup="OnSave" Type="Integer" Display="Dynamic" TabIndex="58">
                                            </asp:RangeValidator>
                                        </td>
                                    </tr>
                                </table>
                            </td>
                        </tr>
                        
                        <%-- Unstable on Turning --%>
                        <tr>
                            <td>
                                &nbsp;
                            </td>
                            <td colspan="2">
                                <!-- Get text in code-behind -->
                                <asp:Label ID="LabelForQ7" runat="server" AssociatedControlID="rblQ7" SkinID="DataLabel" TabIndex="64">
                                </asp:Label> <span class="requiredField">*</span>
                                <br />
                                <%--Unstable Turning Question Choice List--%>
                                <asp:RadioButtonList ID="rblQ7" runat="server" DataSourceID="ObjectDataSourceQ7" TabIndex="65"
                                    DataTextField="CHOICE_TEXT" DataValueField="STD_QUESTION_CHOICE_ID">
                                </asp:RadioButtonList>
                                <br />
                                <%--Unstable Turning Question Required Validator--%>
                                <asp:RequiredFieldValidator ID="RequiredFieldValidatorQ7" runat="server" ControlToValidate="rblQ7"
                                    TabIndex="66" ValidationGroup="OnSave" Display="Dynamic" ErrorMessage="* Unstable Turning is required."></asp:RequiredFieldValidator>
                                <%--Unstable Turning Question Object Data Source--%>
                                <asp:ObjectDataSource ID="ObjectDataSourceQ7" runat="server" SelectMethod="GetChoicesByQuestionNumberandSurveyType"
                                    TypeName="VeteransAffairs.Registries.BusinessManager.TBI.TBIInstrumentsManager">
                                    <SelectParameters>
                                        <asp:ControlParameter ControlID="HiddenSurveyType" Direction="Input" Name="surveyTypeCode" Type="String" />
                                        <asp:ControlParameter ControlID="HiddenQ7" Direction="Input" Name="questionNumber" Type="String" />
                                    </SelectParameters>
                                </asp:ObjectDataSource>
                                <%--Unstable Turning Question Number--%>
                                <asp:HiddenField ID="HiddenQ7" runat="server" Visible="false" Value="7" />
                            </td>
                        </tr>
                                     
                        <!-- Hidden Averages - Only if more than one trial was performed. -->
                        <asp:HiddenField ID="HiddenAverageTime" runat="server" />
                        <asp:HiddenField ID="HiddenAverageDistance" runat="server" />  

                    </table>
                    
                    
                    <!-- End Question Area -->
                    <br />
                </asp:Panel>                        
                       
                <table width="800px">
                    <tr>
                        <td style="width:70px">
                            &nbsp;
                        </td>
                        <td> 
                            <telerik:RadAjaxPanel ID="RadAjaxPanel1" runat="server">
                                <asp:Timer ID="InactiveTimer" Interval="300000" Enabled="true" runat="server" OnTick="InActiveTimer_Tick" />
                            </telerik:RadAjaxPanel>
                            <asp:Button ID="btnSaveSurveyDraft" runat="server" UseSubmitBehavior="true" Text="Save Draft" Width="130px" OnClick="btnSaveSurveyDraft_Click"
                                ValidationGroup="OnSaveDraft" TabIndex="70" />
                            <asp:Button ID="btnSubmitSurvey" runat="server" UseSubmitBehavior="true" Text="Save and Prepare Note" Width="180px" OnClick="btnSubmit_Click"
                                ValidationGroup="OnSave" TabIndex="71" />
                            <asp:Button ID="btnCancelSurvey" runat="server" TabIndex="72" UseSubmitBehavior="false" Text="Cancel" Width="130px" OnClick="btnCancel_Click" />

                        </td>
                    </tr>
                    <tr>
                        <td>
                            &nbsp;
                        </td>
                        <td>
                            <i>                            
                                <b>References</b><br />
                                1. Bohannon RW. Reference values for the Timed Up and Go Test: A Descriptive Meta-Analysis. Journal of Geriatric Physical Therapy, 2006;29(2):64-8.<br />
                                2. Shumway-Cook A, Brauer S, Woollacott M. Predicting the probability for falls in community-dwelling older adults using the timed up & go test. Phys Ther. 2000;80:896-903. <br />
                                3. Kristensen MT, Foss NB, Kehlet H. Timed "Up and Go" Test as a predictor of falls within 6 months after hip fracture surgery. Phys Ther. 2007.87(1):24-30. <br />

                                <br />
                                <b>Additional References</b> <br />
                                Bischoff HA, Stahelin HB, et al. Identifying a cut-off point for normal mobility: A comparison study of the timed "up and go" test in community-dwelling and institutionalized elderly women. Age and Ageing. 2003;32:315-320. <br />
                                Boulgarides LK, McGinty SM, et al. Use of clinical and impairment-based tests to predict falls by community-dwelling older adults. Phys Ther. 2003;83:328-339.<br /> 
                                Podsiadlo D, Richardson S. The timed “up & go": A test of basic functional mobility for frail elderly persons. JAGS. 1991;39:142-148.<br />
                            
                            </i>
                        </td>
                    </tr>
                </table>                

            </ContentTemplate>
        </asp:UpdatePanel>
    </telerik:RadCodeBlock>
</asp:Content>



